package com.bcxin.ferry.scheduling;

import com.bcxin.ferry.configs.BaiduutilServerConfig;
import com.bcxin.ferry.service.FerryTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：创建摆渡任务
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class CreateFerryTask {

    @Autowired
    private FerryTaskService ferryTaskService;
    @Autowired
    private BaiduutilServerConfig baiduutilServerConfig;
    @Value("${spring.profiles.active}")
    private String activeFile;

    @Scheduled(cron = "${scheduling-config.create-ferry-task.cron}")
    public void createFerryTask() {
        log.info("===================================定时创建摆渡任务===================================");

        String regionCodes = baiduutilServerConfig.getRegionCodes();
        log.info("===================================regionCodes：{}===================================", regionCodes);
        for (String regionCode : regionCodes.split(",")) {
            log.info("===================================regionCode：{}===================================", regionCode);
            ferryTaskService.createFerryTask(regionCode);
            if ("in-beijing".equals(activeFile)) {
                log.info("===================================北京内网，需要等5分钟执行下一个===================================");
                try {
                    Thread.sleep(300000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info("===================================5分钟到了===================================");
            }
        }
        log.info("===================================创建摆渡任务结束===================================");
    }

}
