package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.dao.mapper.FerryRequestLogMapper;
import com.bcxin.ferry.entity.FerryRequestLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 摆渡请求日志表(ferry_request_log)服务实现类
 *
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Slf4j
@Service
public class FerryRequestLogService extends ServiceImpl<FerryRequestLogMapper, FerryRequestLogEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：创建请求日志
     * author：linchunpeng
     * date：2024/3/18
     */
    @Transactional
    public Long createLog(Object taskId, Object fileId, Object apiUrl, String requestParam) {
        log.info("创建请求日志");
        FerryRequestLogEntity log = new FerryRequestLogEntity();
        log.setId(snowflake.snowflakeId());
        log.setTaskId(taskId != null ? Long.parseLong(taskId.toString()) : null);
        log.setFileId(fileId != null ? Long.parseLong(fileId.toString()) : null);
        log.setApiUrl(apiUrl != null ? apiUrl.toString() : null);
        JSONObject jsonObject = JSONObject.parseObject(requestParam);
        jsonObject.keySet().removeIf("img_base64"::equals);
        jsonObject.keySet().removeIf("paramContent"::contains);
        log.setRequestParam(JSONObject.toJSONString(jsonObject));
        log.setFerryStatus(1);
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        this.save(log);
        return log.getId();
    }


    /**
     * description：更新请求日志
     * author：linchunpeng
     * date：2024/3/18
     */
    @Transactional
    public void updateLogRequestResult(Long id, String requestResult, String boundaryTaskId) {
        log.info("更新请求日志");
        FerryRequestLogEntity log = this.getById(id);
        log.setRequestResult(requestResult);
        log.setBoundaryTaskId(boundaryTaskId);
        log.setFerryStatus(2);
        log.setApiReturnTime(new Date());
        log.setUpdateTime(new Date());
        this.updateById(log);
    }


    /**
     * description：边界服务回调
     * author：linchunpeng
     * date：2024/3/18
     */
    @Async(value = "taskExecutor")
    @Transactional
    public void boundaryServerCallback(String boundaryTaskId) {
        log.info("边界服务回调，修改状态");
        LambdaQueryChainWrapper<FerryRequestLogEntity> lqw = this.lambdaQuery();
        lqw.eq(FerryRequestLogEntity::getBoundaryTaskId, boundaryTaskId);
        lqw.orderByDesc(FerryRequestLogEntity::getCreateTime);
        lqw.last("limit 1");
        List<FerryRequestLogEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            FerryRequestLogEntity log = list.get(0);
            log.setFerryStatus(3);
            log.setSuccessTime(new Date());
            log.setUpdateTime(new Date());
            this.updateById(log);
        }
    }
}