package com.bcxin.ferry.scheduling;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.ferry.service.FerryTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * description：查询摆渡任务状态-拉取完成
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class QueryPullComplete {

    @Autowired
    private FerryTaskService ferryTaskService;

    @Scheduled(cron = "${scheduling-config.query-pull-complete.cron}")
    public void queryPullComplete() {
        log.info("===================================定时查询摆渡任务状态-拉取完成===================================");
        ferryTaskService.queryPullIsComplete();
        List<Long> canInitTaskIdList = ferryTaskService.queryPullComplete();
        if (CollectionUtil.isNotEmpty(canInitTaskIdList)) {
            for (Long taskId : canInitTaskIdList) {
                ferryTaskService.initFileInfo(taskId);
            }
        } else {
            log.info("没有最近一次拉取完成的任务");
        }
        log.info("===================================查询摆渡任务状态-拉取完成结束===================================");
    }

}
