package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

 /**
 * 接收任务文件表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_receive_task_file")
public class FerryReceiveTaskFileEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id(文件id)
    @TableId(value = "id")
    private Long id;
    
    //接收任务id
    private Long taskId;
    
    //文件类型，1-任务文件，2-sql文件，3-普通文件，4-子文件（拆分），5-txt文件，6-特殊字符名称文件
    private Integer fileType;
    
    //文件名称
    private String fileName;
    
    //文件md5
    private String fileMd5;
    
    //文件存储url
    private String fileUrl;
    
    //文件状态，1-初始化完成，2-接收完成
    private Integer fileStatus;
    
    //文件大小，kb
    private BigDecimal fileSize;
    
    //是否拆分，1-是，0-否（是拆分的话，文件不摆渡）
    private Integer isSplit;
    
    //合并状态，1-未合并，2-已合并
    private Integer mergeStatus;
    
    //拆分文件的ids，,隔开
    private String splitFileIds;
    
    //接收文件md5
    private String receiveFileMd5;
    
    //接收结果
    private String receiveResult;
    
    //执行状态，1-等待执行，2-执行中，3-执行完成
    private Integer executeStatus;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}