package com.bcxin.ferry.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.CommonConstant;
import com.bcxin.ferry.dtos.response.boundary.BoundaryCallbackResult;
import com.bcxin.ferry.dtos.FerryFileDto;
import com.bcxin.ferry.strategy.receive.ReceiveStrategyFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * description：接口接收
 * author：linchunpeng
 * date：2024/3/13
 */
@Slf4j
@RestController
@RequestMapping("/api/receive")
public class ApiReceiveController {

    /**
     * description：接收任务文件
     * author：linchunpeng
     * date：2024/3/13
     */
    @PostMapping("/ferry/task/file")
    public BoundaryCallbackResult ferryTaskFile(@RequestBody Map<String, Object> data) {
        ReceiveStrategyFactory.getInstance(CommonConstant.RECEIVE_STRATEGY_KEY_TASK_FILE).handle(JSONObject.toJSONString(data));
        return new BoundaryCallbackResult("0", "接收成功");
    }

    /**
     * description：接收明细文件
     * author：linchunpeng
     * date：2024/3/13
     */
    @PostMapping("/ferry/detail/file")
    public BoundaryCallbackResult ferryDetailFile(@RequestBody Map<String, Object> data) {
        ReceiveStrategyFactory.getInstance(CommonConstant.RECEIVE_STRATEGY_KEY_DETAIL_FILE).handle(JSONObject.toJSONString(data));
        return new BoundaryCallbackResult("0", "接收成功");
    }

}
