package com.bcxin.ferry.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.dtos.FerryDto;
import com.bcxin.ferry.dtos.response.boundary.BoundaryCallbackResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * description：其他消息接收
 * author：linchunpeng
 * date：2024/3/13
 */
@Slf4j
@RestController
@RequestMapping("/api/other")
public class ApiIOtherController {

    /**
     * description：接收其他消息
     * author：linchunpeng
     * date：2024/3/13
     */
    @PostMapping("/message")
    public BoundaryCallbackResult message(@RequestBody Map<String, Object> data) {
        log.info("参数：{}", JSONObject.toJSONString(data));
        return new BoundaryCallbackResult("0", "接收成功");
    }

}
