package com.bcxin.ferry.common.emus;

/**
 * 响应状态枚举 其中600以前为保留代码 系统重要使用800以后的代码 代码规范为3位数
 */
public enum StatusCode {
    /**
     * 操作成功
     */
    succeed(200, "操作成功"),

    /**
     * 未知错误
     */
    unknown(-1, "未知错误"),
    /**
     * 未实现功能错误
     */
    notImplemented(-2, "未实现的功能"),
    /**
     * 访问资源不存在
     */
    notfound(601, "访问资源不存在"),

    /**
     * 错误的请求方式
     */
    methodNotAllowed(602, "错误的请求方式"),

    /**
     * 参数校验异常
     */
    parameterError(603, "参数校验异常"),

    /**
     * 断言异常
     */
    assertError(605, "业务处理所需资源校验异常"),

    /**
     * 远程异常（第三方调用异常）
     */
    remoteError(999, "调研第三方接口异常"),
    /**
     * 没有权限
     */
    unauthorized(700, "没有操作权限"),

    /**
     * 业务逻辑处理异常
     */
    serviceError(701, "系统处理业务逻辑异常"),
    /**
     * 令牌错误
     */
    tokenError(702, "错误的用户令牌"),
    /**
     * 数据签名错误
     */
    signatureError(703, "数据签名错误"),
    /**
     * 登录失败
     */
    loginError(704, "登录失败");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    StatusCode(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
