package com.bcxin.ferry.ascept;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.CommonConstant;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

/**
 * description：鉴权切面
 * author：linchunpeng
 * date：2023/11/7
 */
@Slf4j
@Component
@Aspect
public class AuthAspect {
//
//    @Value("${api-auth.admin-secret}")
//    private String adminSecret;


    /**
     * 路径校验器
     */
    private AntPathMatcher antPathMatcher =  new AntPathMatcher();

    /**
     * description：环绕切面
     * author：linchunpeng
     * date：2023/11/15
     */
    @Around("execution(* com.bcxin.ferry.controller.*.*(..))")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();

        String appid = request.getHeader(CommonConstant.MSG_REQUEST_HEADER_APPID);
        String secret = request.getHeader(CommonConstant.MSG_REQUEST_HEADER_SECRET);

        String requestId = UUID.randomUUID(). toString();
        log.info("请求id：{}，请求地址：{}，请求头部：appid={}，secret={}",
                requestId, request.getRequestURI(), appid, secret);

        request.setAttribute(CommonConstant.API_REQUEST_ID, requestId);

        if(this.isMatch(request.getRequestURI(), getPublicUris())) {
            Object proceed = proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
            log.info("请求id：{}，请求地址：{}，返回参数：{}", requestId, request.getRequestURI(), JSONObject.toJSONString(proceed));
            return proceed;
        }

//        AssertUtils.isNotEmptyString(appid, "appid不能为空");
//        AssertUtils.isNotEmptyString(secret, "secret不能为空");

        Object proceed = proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());

        log.info("请求id：{}，请求地址：{}，返回参数：{}", requestId, request.getRequestURI(), JSONObject.toJSONString(proceed));
        return proceed;
    }

    /**
     * description：实付匹配
     * author：linchunpeng
     * date：2023/11/15
     */
    private boolean isMatch(String url, List<String> uris) {
        if(uris==null){
            return false;
        }
        for (String uri : uris) {
            if (this.antPathMatcher.match(uri, url)) {
                return true;
            }
        }
        return false;
    }

    /**
     * description：不需要鉴权的接口url
     * author：linchunpeng
     * date：2023/11/15
     */
    private List<String> getPublicUris() {
        return Arrays.asList("/zidingyi", "/zidingyi2");
    }
}
