/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.utils;

import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageDataJsonSnapshot;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageValueSnapshot;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DynamicPageDataEntityUtils {
    public static DynamicPageDataEntity translate2PageDataEntity(Map<String, Object> params, JsonProvider jsonProvider) {
        String id = (String)params.get("id");
        HashMap<String, Object> rt = new HashMap<String, Object>();
        String sysJsonValue = (String)params.get("sys_dynamic_json");
        DynamicPageValueSnapshot snapshot = (DynamicPageValueSnapshot)((Object)jsonProvider.toObject(DynamicPageValueSnapshot.class, sysJsonValue));
        if (snapshot == null) {
            snapshot = DynamicPageValueSnapshot.empty();
        }
        if (CollectionUtils.isEmpty(snapshot.getColumnMappings())) {
            params.forEach((k, v) -> {
                if (!"sys_dynamic_json".equals(k)) {
                    rt.put((String)k, v);
                }
            });
        } else {
            HashSet<String> allKeys = new HashSet<String>();
            allKeys.addAll(params.keySet());
            allKeys.addAll(snapshot.getItems().keySet());
            Iterator iterator = allKeys.iterator();
            while (iterator.hasNext()) {
                Object orValue;
                String rqKey;
                String orKey;
                String mappedKey = orKey = (String)iterator.next();
                if (snapshot.getColumnMappings().containsKey(orKey)) {
                    mappedKey = snapshot.getColumnMappings().get(orKey);
                }
                if ((rqKey = snapshot.getColumnMappings().get(mappedKey)) == null) {
                    rqKey = mappedKey;
                }
                if ((orValue = params.get(mappedKey)) == null) {
                    orValue = snapshot.getItems().get(mappedKey);
                }
                if ("$.extends".equals(rqKey) || "current".equals(rqKey) || "creator_id".equals(rqKey) || "last_updater_id".equals(rqKey)) continue;
                if ("sys_dynamic_json".equals(rqKey)) {
                    rt.put(rqKey, jsonProvider.toObject(DynamicPageDataJsonSnapshot.class, String.valueOf(orValue)));
                    continue;
                }
                rt.put(rqKey, orValue);
            }
        }
        DynamicPageDataJsonSnapshot sn = DynamicPageDataJsonSnapshot.create(rt);
        LocalDateTime createdTime = (LocalDateTime)rt.get("created_time");
        LocalDateTime lastUpdatedTime = (LocalDateTime)rt.get("last_updated_time");
        return DynamicPageDataEntity.createForMappingData(id, snapshot.getPageId(), snapshot.getVersion(), snapshot.getBusinessType(), sn, (String)rt.get("domain_id"), (String)rt.get("last_updater_id"), (String)rt.get("creator_id"), createdTime == null ? null : Timestamp.valueOf(createdTime), lastUpdatedTime == null ? null : Timestamp.valueOf(lastUpdatedTime), jsonProvider);
    }
}

