/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.aspects;

import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import java.lang.reflect.Field;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TenantUserContextAspect {
    private static final Logger logger = LoggerFactory.getLogger(TenantUserContextAspect.class);

    @Before(value="execution(* com.bcxin.tenant.bcx.domains.services.impls.*ServiceImpl.dispatch(..))")
    public void fillTenantUserContext(JoinPoint joinPoint) {
        try {
            Object[] args = joinPoint.getArgs();
            if (args == null || args.length == 0) {
                return;
            }
            Object command = args[0];
            if (command == null) {
                return;
            }
            TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
            if (userModel == null) {
                logger.warn("TenantContext\u4e2d\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8df3\u8fc7\u81ea\u52a8\u586b\u5145");
                return;
            }
            MetaCreatorReferenceType referenceType = userModel.getUserType();
            String referenceNumber = userModel.getOrganizationId();
            String id = userModel.getId();
            this.setFieldValue(command, "referenceType", referenceType);
            this.setFieldValue(command, "referenceNumber", referenceNumber);
            this.setFieldValue(command, "creatorId", id);
            this.setFieldValue(command, "lastUpdaterId", id);
            logger.debug("\u6210\u529f\u586b\u5145\u7528\u6237\u4e0a\u4e0b\u6587\u4fe1\u606f\u5230command\u5bf9\u8c61: referenceType={}, referenceNumber={}, id={}", new Object[]{referenceType, referenceNumber, id});
        }
        catch (Exception ex) {
            logger.error("\u586b\u5145\u7528\u6237\u4e0a\u4e0b\u6587\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    private void setFieldValue(Object target, String fieldName, Object value) {
        try {
            Field field = this.findField(target.getClass(), fieldName);
            if (field == null) {
                logger.debug("\u5b57\u6bb5 {} \u5728 {} \u4e2d\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7", (Object)fieldName, (Object)target.getClass().getSimpleName());
                return;
            }
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            logger.warn("\u65e0\u6cd5\u8bbf\u95ee\u5b57\u6bb5 {} \u5728 {}: {}", new Object[]{fieldName, target.getClass().getSimpleName(), e.getMessage()});
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u5b57\u6bb5 {} \u65f6\u53d1\u751f\u5f02\u5e38", (Object)fieldName, (Object)e);
        }
    }

    private Field findField(Class<?> clazz, String fieldName) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

