package com.bcxin.tenant.bcx.domains.services.commands.pages;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Getter;

import java.sql.Timestamp;
import java.util.Date;


/**
 * 创建页面元数据命令
 */
@Getter
public class CreateMetaPageCommand extends CommandAbstract {
    private final String projectId;
    private final String moduleId;
    private final String name;
    private final String note;
    private final String formJson;
    private final String slug;
    private final String logo;
    private final PageType pageType;
    private final PageBusinessType businessType;
    private final String tableName;
    private final boolean enableBPMFlow;
    private final boolean enableAnonymousAccess;
    private final boolean sync2Identity;
    private final Timestamp beginTime;
    private final Timestamp endTime;

    private final String attachment;

    private final int limitedCount;

    public CreateMetaPageCommand(String projectId, String moduleId, String name,
                                 String note, String formJson, String slug,
                                 String logo, PageType pageType, PageBusinessType businessType,
                                 String tableName, boolean enableBPMFlow, boolean enableAnonymousAccess,
                                 boolean sync2Identity,Timestamp beginTime,Timestamp endTime,
                                 String attachment,int limitedCount) {
        this.projectId = projectId;
        this.moduleId = moduleId;
        this.name = name;
        this.note = note;
        this.formJson = formJson;
        this.slug = slug;
        this.logo = logo;
        this.pageType = pageType;
        this.businessType = businessType;
        this.tableName = tableName;
        this.enableBPMFlow = enableBPMFlow;
        this.enableAnonymousAccess = enableAnonymousAccess;
        this.sync2Identity = sync2Identity;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.attachment = attachment;
        this.limitedCount = limitedCount;
    }

    public static CreateMetaPageCommand create(String projectId, String moduleId, String name,
                                               String note, String formJson, String slug,
                                               String logo, PageType pageType, PageBusinessType businessType,
                                               String tableName, boolean enableBPMFlow, boolean enableAnonymousAccess,
                                               boolean sync2Identity,Timestamp beginTime,Timestamp endTime,
                                               String attachment,int limitedCount
    ) {
        return new CreateMetaPageCommand(projectId, moduleId, name, note,
                formJson, slug, logo, pageType, businessType, tableName, enableBPMFlow,
                enableAnonymousAccess,sync2Identity,beginTime,endTime,attachment,limitedCount);
    }
}

