package com.bcxin.tenant.bcx.domains.services.commands.pages;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;

import java.util.List;

/**
 * 批量逻辑删除页面命令
 */
public class BatchLogicalDeletePageCommand extends CommandAbstract {
    private final List<String> ids;

    public BatchLogicalDeletePageCommand(List<String> ids) {
        this.ids = ids;
    }

    public List<String> getIds() {
        return ids;
    }

    @Override
    public void validate() {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("页面ID列表不能为空");
        }
    }
}

