package com.bcxin.tenant.bcx.domains.services.commands.organregistry;

import com.bcxin.tenant.bcx.infrastructures.commands.CommandAbstract;

import java.util.List;

/**
 * 批量逻辑删除企业注册表单命令
 */
public class BatchLogicalDeleteOrganRegistryFormsCommand extends CommandAbstract {
    private final List<String> ids;

    public BatchLogicalDeleteOrganRegistryFormsCommand(List<String> ids) {
        this.ids = ids;
    }

    public List<String> getIds() {
        return ids;
    }

    @Override
    public void validate() {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("ID列表不能为空");
        }
        for (String id : ids) {
            if (id == null || id.trim().isEmpty()) {
                throw new IllegalArgumentException("ID不能为空");
            }
        }
    }
}
