package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import lombok.Data;

/**
 * 科目及授权信息
 */
@Data
@TableName(value = "bus_exam_subjects", autoResultMap = true)
public class ExamSubjectEntity extends EntityAbstract implements Aggregate {
    @TableId
    private String id;
    @TableField
    private String name;
    /**
     * 机构类型编码，关联sys_institutional_types.code
     */
    @TableField(value = "institutional_type_code")
    private String institutionalTypeCode;

    /**
     * 行业类型编码，关联sys_industry_types.code
     */
    @TableField(value = "industry_type_code")
    private String industryTypeCode;

    /**
     * 监管区域编码
     */
    @TableField(value = "region_code")
    private String regionCode;

    /**
     * 授权信息
     */
    @TableField(value = "permission_json")
    private String permissionJson;
}
