package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.CommonSettingDataType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "sys_common_data_settings",autoResultMap = true)
@Data
public class CommonDataSettingEntity extends EntityAbstract implements Aggregate {

    @TableId(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;
    @TableField(value = "note")
    private String note;
    @TableField(value = "data_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private CommonSettingDataType dataType;
    @TableField(value = "`condition`")
    private String condition;
    @TableField(value = "data_value")
    private String dataValue;
    @TableField(value = "enabled")
    private boolean enabled;
    @TableField(value = "created_time")
    private Timestamp createdTime;
}
