/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.domains.components.CacheProvider;
import com.bcxin.tenant.bcx.domains.entities.MetaPageEntity;
import com.bcxin.tenant.bcx.domains.mappers.MetaPageMapper;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageRepository;
import com.bcxin.tenant.bcx.domains.repositories.RepositoryAbstract;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaPageSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class MetaPageRepositoryImpl
extends RepositoryAbstract<MetaPageEntity>
implements MetaPageRepository {
    private final MetaPageMapper mapper;
    private final CacheProvider cacheProvider;

    protected MetaPageRepositoryImpl(MetaPageMapper mapper, CacheProvider cacheProvider) {
        super(mapper);
        this.mapper = mapper;
        this.cacheProvider = cacheProvider;
    }

    public EntityCollection<MetaPageEntity> search(MetaPageSearchCriteria criteria) {
        List ids;
        Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MetaPageEntity::isDeleted, (Object)false);
        if (!StringUtil.isEmpty((String)criteria.getId())) {
            queryWrapper.eq(MetaPageEntity::getId, (Object)criteria.getId());
        }
        if ((ids = criteria.getIds()) != null && !ids.isEmpty()) {
            queryWrapper.in(MetaPageEntity::getId, (Collection)ids);
        }
        if (!StringUtil.isEmpty((String)criteria.getProjectId())) {
            queryWrapper.eq(MetaPageEntity::getProjectId, (Object)criteria.getProjectId());
        }
        if (!StringUtil.isEmpty((String)criteria.getModuleId())) {
            queryWrapper.eq(MetaPageEntity::getModuleId, (Object)criteria.getModuleId());
        }
        if (!StringUtil.isEmpty((String)criteria.getName())) {
            queryWrapper.like(MetaPageEntity::getName, (Object)criteria.getName());
        }
        if (!StringUtil.isEmpty((String)criteria.getSlug())) {
            queryWrapper.eq(MetaPageEntity::getSlug, (Object)criteria.getSlug());
        }
        if (criteria.getPageTypes() != null && !criteria.getPageTypes().isEmpty()) {
            List pageTypeOrdinals = criteria.getPageTypes().stream().map(Enum::ordinal).collect(Collectors.toList());
            queryWrapper.in(MetaPageEntity::getPageType, pageTypeOrdinals);
        } else if (criteria.getPageType() != null) {
            queryWrapper.eq(MetaPageEntity::getPageType, (Object)criteria.getPageType().ordinal());
        }
        if (criteria.getBusinessTypes() != null && !criteria.getBusinessTypes().isEmpty()) {
            List businessTypeOrdinals = criteria.getBusinessTypes().stream().map(Enum::ordinal).collect(Collectors.toList());
            queryWrapper.in(MetaPageEntity::getBusinessType, businessTypeOrdinals);
        } else if (criteria.getBusinessType() != null) {
            queryWrapper.eq(MetaPageEntity::getBusinessType, (Object)criteria.getBusinessType().ordinal());
        }
        if (!StringUtil.isEmpty((String)criteria.getTableName())) {
            queryWrapper.like(MetaPageEntity::getTableName, (Object)criteria.getTableName());
        }
        if (criteria.getEnableBPMFlow() != null) {
            queryWrapper.eq(MetaPageEntity::isEnableBPMFlow, (Object)criteria.getEnableBPMFlow());
        }
        queryWrapper.orderByDesc(MetaPageEntity::getCreatedTime);
        IPage result = this.mapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return EntityCollection.create((Collection)result.getRecords(), (int)criteria.getPageSize(), (Long)result.getTotal());
    }

    public List<MetaPageEntity> getByIds(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.mapper.selectBatchIds(ids);
    }

    public void batchMarkAsDeleted(List<String> ids, Timestamp updateTime) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.in(MetaPageEntity::getId, ids)).eq(MetaPageEntity::isDeleted, (Object)false)).set(MetaPageEntity::isDeleted, (Object)true)).set(MetaPageEntity::getLastUpdatedTime, (Object)updateTime);
        this.mapper.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void delete(Object id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(MetaPageEntity::getId, id)).eq(MetaPageEntity::isDeleted, (Object)false)).set(MetaPageEntity::isDeleted, (Object)true)).set(MetaPageEntity::getLastUpdatedTime, (Object)Timestamp.from(Instant.now()));
        this.mapper.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public MetaPageEntity getById(Object id) {
        return (MetaPageEntity)super.getById(id);
    }

    @Override
    public void update(MetaPageEntity data) {
        super.update(data);
    }
}

