/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.domains.components.CacheProvider;
import com.bcxin.tenant.bcx.domains.criterias.DynamicPageDataCriteria;
import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.mappers.DynamicPageDataMapper;
import com.bcxin.tenant.bcx.domains.repositories.DynamicPageDataRepository;
import com.bcxin.tenant.bcx.domains.repositories.MetaPageTableMappingRepository;
import com.bcxin.tenant.bcx.domains.repositories.RepositoryAbstract;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.domains.utils.DynamicPageDataEntityUtils;
import com.bcxin.tenant.bcx.domains.wrappers.DynamicDataWrapper;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ConflictTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ForbidTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.tenant.bcx.infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class DynamicPageDataRepositoryImpl
extends RepositoryAbstract<DynamicPageDataEntity>
implements DynamicPageDataRepository {
    private static final Logger logger = LoggerFactory.getLogger(DynamicPageDataRepositoryImpl.class);
    private final MetaPageTableMappingRepository tableMappingRepository;
    private final CacheProvider cacheProvider;
    private final DynamicPageDataMapper dynamicPageDataMapper;
    private final JsonProvider jsonProvider;

    protected DynamicPageDataRepositoryImpl(DynamicPageDataMapper mapper, MetaPageTableMappingRepository tableMappingRepository, CacheProvider cacheProvider, JsonProvider jsonProvider) {
        super(mapper);
        this.dynamicPageDataMapper = mapper;
        this.tableMappingRepository = tableMappingRepository;
        this.cacheProvider = cacheProvider;
        this.jsonProvider = jsonProvider;
    }

    public EntityCollection<DynamicPageDataEntity> search(DynamicPageDataCriteria criteria) {
        DynamicPageTableMappingDataSnapshot snapshot = null;
        snapshot = !StringUtils.hasLength((String)criteria.getMappingId()) ? this.tableMappingRepository.getSnapshot(criteria.getPageId()) : this.tableMappingRepository.getSnapshotByMappingId(criteria.getMappingId());
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            DynamicDataWrapper wrapper = DynamicDataWrapper.createForSearch((DynamicPageTableMappingDataSnapshot)snapshot, (Map)criteria.getFiledKeyValueMap(), (boolean)criteria.ignorePage(), (int)criteria.getPageIndex(), (int)criteria.getPageSize());
            wrapper = this.getWrappedWrapper(wrapper);
            Collection<Map<String, Object>> rt = this.dynamicPageDataMapper.dynamicSearch(wrapper);
            long count = this.dynamicPageDataMapper.dynamicCount(wrapper);
            Collection entities = rt.stream().map(ii -> DynamicPageDataEntityUtils.translate2PageDataEntity((Map)ii, (JsonProvider)this.jsonProvider)).collect(Collectors.toList());
            return EntityCollection.create((Collection)entities, (int)criteria.getPageSize(), (Long)count);
        }
        if (StringUtils.hasLength((String)criteria.getMappingId())) {
            throw new NoFoundTenantException(String.format("\u6620\u5c04\u8868\u5355(%s)\u65e0\u6548", criteria.getPageId()));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DynamicPageDataEntity::getPageId, (Object)criteria.getPageId());
        if (!CollectionUtils.isEmpty((Collection)criteria.getFields())) {
            block11: for (DynamicConditionFieldValueType field : criteria.getFields()) {
                if (field.getValue() == null) continue;
                if (!StringUtils.hasLength((String)field.getType())) {
                    logger.warn("\u975e\u9884\u671f\u6570\u636e;\u5b57\u6bb5(page={}, field={})\u7c7b\u578b\u4e0d\u5e94\u8be5\u4e3a\u7a7a", (Object)criteria.getPageId(), (Object)field.getField());
                    continue;
                }
                switch (field.getType()) {
                    case "datePicker": 
                    case "timePicker": {
                        List values = (List)field.getValue();
                        if (CollectionUtils.isEmpty((Collection)values) || values.size() != 2) continue block11;
                        String whereSql = String.format("(data_json ->>'$.items.%s' >= {0} and data_json ->>'$.items.%s' <= {1})", field.getField(), field.getField());
                        lambdaQueryWrapper.apply(whereSql, new Object[]{values.get(0), values.get(1)});
                        continue block11;
                    }
                    case "inputNumber": {
                        Collection numbers = (Collection)field.getValue();
                        lambdaQueryWrapper.apply(String.format("(data_json ->>'$.items.%s' = {0})", field.getField()), new Object[]{field.getValue()});
                        continue block11;
                    }
                    case "input": {
                        lambdaQueryWrapper.apply(String.format("(data_json ->>'$.items.%s' like {0})", field.getField()), new Object[]{field.getValue() + "%"});
                        continue block11;
                    }
                }
                lambdaQueryWrapper.apply(String.format("(data_json ->>'$.items.%s' = {0})", field.getField()), new Object[]{field.getValue()});
            }
        }
        lambdaQueryWrapper.last("order by created_time desc,last_updated_time desc");
        if (criteria.isForExport()) {
            List entities = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
            return EntityCollection.create((Collection)entities, (int)criteria.getPageSize(), (Long)Long.valueOf(entities.size()));
        }
        Page page = new Page((long)criteria.getPageIndex(), (long)criteria.getPageSize());
        IPage pageDataEntityIPage = this.mapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
        return EntityCollection.create((Collection)pageDataEntityIPage.getRecords(), (int)((int)pageDataEntityIPage.getSize()), (Long)pageDataEntityIPage.getTotal());
    }

    public DynamicPageDataEntity getById(String pageId, String id) {
        DynamicPageTableMappingDataSnapshot snapshot = this.tableMappingRepository.getSnapshot(pageId);
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            DynamicDataWrapper wrapper = DynamicDataWrapper.createForGetAndDeleteAction((DynamicPageTableMappingDataSnapshot)snapshot, (String)pageId, (String)id);
            Map<String, Object> items = this.dynamicPageDataMapper.getDslById(wrapper = this.getWrappedWrapper(wrapper));
            if (CollectionUtils.isEmpty(items)) {
                throw new NoFoundTenantException();
            }
            return DynamicPageDataEntityUtils.translate2PageDataEntity(items, (JsonProvider)this.jsonProvider);
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DynamicPageDataEntity::getPageId, (Object)pageId);
        lambdaQueryWrapper.eq(DynamicPageDataEntity::getId, (Object)id);
        return (DynamicPageDataEntity)this.mapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    public void delete(String pageId, String id) {
        DynamicPageTableMappingDataSnapshot snapshot = this.tableMappingRepository.getSnapshot(pageId);
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            int affectCount = this.dynamicPageDataMapper.dynamicDelete(DynamicDataWrapper.createForGetAndDeleteAction((DynamicPageTableMappingDataSnapshot)snapshot, (String)pageId, (String)id));
            if (affectCount < 1) {
                throw new ForbidTenantException("\u8be5\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DynamicPageDataEntity::getPageId, (Object)pageId);
        lambdaQueryWrapper.eq(DynamicPageDataEntity::getId, (Object)id);
        int affectedCount = this.mapper.delete((Wrapper)lambdaQueryWrapper);
        if (affectedCount != 1) {
            logger.warn("\u975e\u9884\u671f\u6570\u636e;pageId={},id={}\u6570\u636e\u4e0d\u5b58\u5728", (Object)pageId, (Object)id);
            throw new NoFoundTenantException();
        }
    }

    public void batchInsert(Collection<DynamicPageDataEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        List pageIds = entities.stream().map(ii -> ii.getPageId()).distinct().collect(Collectors.toList());
        if (pageIds.size() > 1) {
            throw new NotSupportTenantException("\u4e0d\u652f\u6301\u540c\u65f6\u6279\u91cf\u5904\u7406\u591a\u9875\u9762\u6570\u636e");
        }
        String pageId = (String)pageIds.get(0);
        DynamicPageTableMappingDataSnapshot snapshot = this.tableMappingRepository.getSnapshot(pageId);
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            try {
                Collection wrappers = entities.stream().map(ii -> DynamicDataWrapper.create((DynamicPageTableMappingDataSnapshot)snapshot, (DynamicPageDataEntity)ii, (JsonProvider)this.jsonProvider, (DoActionType)DoActionType.Create)).collect(Collectors.toList());
                for (DynamicDataWrapper wrapper : wrappers) {
                    this.dynamicPageDataMapper.dynamicInsertOnDuplicateUpdate(wrapper);
                }
            }
            catch (Exception ex) {
                if (!CollectionUtils.isEmpty((Map)snapshot.getValidationRules())) {
                    String error = ExceptionUtil.getStackMessage((Throwable)ex);
                    for (String identity : snapshot.getValidationRules().keySet()) {
                        if (!error.contains(identity)) continue;
                        throw new ConflictTenantException(String.valueOf(snapshot.getValidationRules().get(identity)));
                    }
                }
                throw ExceptionUtil.returnExpectedException((Exception)ex, (String)"\u6570\u636e\u4fdd\u5b58\u5f02\u5e38");
            }
            return;
        }
        for (DynamicPageDataEntity data : entities) {
            super.insert(data);
        }
    }

    public void doAction(DynamicPageDataEntity data, DoActionType actionType) {
        DynamicPageTableMappingDataSnapshot snapshot = this.tableMappingRepository.getSnapshot(data.getPageId());
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            DynamicDataWrapper wrapper = DynamicDataWrapper.create((DynamicPageTableMappingDataSnapshot)snapshot, (DynamicPageDataEntity)data, (JsonProvider)this.jsonProvider, (DoActionType)actionType);
            int affectedCount = this.dynamicPageDataMapper.dynamicDoAction(wrapper);
            if (affectedCount < 1) {
                logger.error("\u65e0\u5f71\u54cd\u6570\u636e\u884c:{} \u53c2\u6570={}", (Object)wrapper.getActionDsl(), (Object)wrapper.getParams());
            }
            return;
        }
        super.update(data);
    }

    @Override
    public void insert(DynamicPageDataEntity data) {
        DynamicPageTableMappingDataSnapshot snapshot = this.tableMappingRepository.getSnapshot(data.getPageId());
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            try {
                DynamicDataWrapper wrapper = DynamicDataWrapper.create((DynamicPageTableMappingDataSnapshot)snapshot, (DynamicPageDataEntity)data, (JsonProvider)this.jsonProvider, (DoActionType)DoActionType.Create);
                int affectedCount = this.dynamicPageDataMapper.dynamicInsert(wrapper);
                if (affectedCount < 1) {
                    throw new ConflictTenantException("\u8be5\u6570\u636e\u5df2\u91cd\u590d");
                }
                return;
            }
            catch (Exception ex) {
                logger.error("\u6570\u636e\u4fdd\u5b58\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
                if (!CollectionUtils.isEmpty((Map)snapshot.getValidationRules())) {
                    String error = ExceptionUtil.getStackMessage((Throwable)ex);
                    for (String identity : snapshot.getValidationRules().keySet()) {
                        if (!error.contains(identity)) continue;
                        throw new ConflictTenantException(String.valueOf(snapshot.getValidationRules().get(identity)));
                    }
                }
                throw ExceptionUtil.returnExpectedException((Exception)ex, (String)"\u6570\u636e\u4fdd\u5b58\u5f02\u5e38");
            }
        }
        super.insert(data);
    }

    @Override
    public void update(DynamicPageDataEntity data) {
        DynamicPageTableMappingDataSnapshot snapshot = this.tableMappingRepository.getSnapshot(data.getPageId());
        if (!DynamicPageTableMappingDataSnapshot.isEmpty((DynamicPageTableMappingDataSnapshot)snapshot)) {
            this.dynamicPageDataMapper.dynamicUpdate(DynamicDataWrapper.create((DynamicPageTableMappingDataSnapshot)snapshot, (DynamicPageDataEntity)data, (JsonProvider)this.jsonProvider, (DoActionType)DoActionType.Update));
            return;
        }
        super.update(data);
    }

    @Override
    public void delete(Object id) {
        throw new NotSupportTenantException();
    }

    private DynamicDataWrapper getWrappedWrapper(DynamicDataWrapper wrapper) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel != null) {
            wrapper.addParams(userModel.fillAndReturnMap(wrapper.getParams()));
            wrapper.assignCurrentUser(userModel);
        }
        return wrapper;
    }
}

