package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.domains.entities.BusOrganRegistryFormsEntity;
import com.bcxin.tenant.bcx.domains.mappers.BusOrganRegistryFormsMapper;
import com.bcxin.tenant.bcx.domains.repositories.criterias.OrganRegistryFormsSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import org.springframework.stereotype.Repository;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

/**
 * 企业注册表单仓库实现
 */
@Repository
public class OrganRegistryFormsRepositoryImpl extends RepositoryAbstract<BusOrganRegistryFormsEntity> implements OrganRegistryFormsRepository {
    private final BusOrganRegistryFormsMapper mapper;

    protected OrganRegistryFormsRepositoryImpl(BusOrganRegistryFormsMapper mapper) {
        super(mapper);
        this.mapper = mapper;
    }

    @Override
    public EntityCollection<BusOrganRegistryFormsEntity> search(OrganRegistryFormsSearchCriteria criteria) {
        // 创建 Page 对象
        Page<BusOrganRegistryFormsEntity> page = new Page<>(criteria.getPageIndex(), criteria.getPageSize());

        // 使用 LambdaQueryWrapper 构建查询条件
        LambdaQueryWrapper<BusOrganRegistryFormsEntity> queryWrapper = new LambdaQueryWrapper<>();
        
        // deleted = 0
        queryWrapper.eq(BusOrganRegistryFormsEntity::isDeleted, false);
        
        // id = #{criteria.id}
        if (!StringUtil.isEmpty(criteria.getId())) {
            queryWrapper.eq(BusOrganRegistryFormsEntity::getId, criteria.getId());
        }
        
        // id IN (...)
        List<String> ids = criteria.getIds();
        if (ids != null && !ids.isEmpty()) {
            queryWrapper.in(BusOrganRegistryFormsEntity::getId, ids);
        }
        
        // institutional_type_code LIKE CONCAT('%',#{criteria.institutionalTypeCode},'%')
        if (!StringUtil.isEmpty(criteria.getInstitutionalTypeCode())) {
            queryWrapper.like(BusOrganRegistryFormsEntity::getInstitutionalTypeCode, criteria.getInstitutionalTypeCode());
        }
        
        // industry_type_code LIKE CONCAT('%',#{criteria.industryTypeCode},'%')
        if (!StringUtil.isEmpty(criteria.getIndustryTypeCode())) {
            queryWrapper.like(BusOrganRegistryFormsEntity::getIndustryTypeCode, criteria.getIndustryTypeCode());
        }
        
        // region_code LIKE CONCAT('%',#{criteria.regionCode},'%')
        if (!StringUtil.isEmpty(criteria.getRegionCode())) {
            queryWrapper.like(BusOrganRegistryFormsEntity::getRegionCode, criteria.getRegionCode());
        }
        
        // page_id = #{criteria.pageId}
        if (!StringUtil.isEmpty(criteria.getPageId())) {
            queryWrapper.eq(BusOrganRegistryFormsEntity::getPageId, criteria.getPageId());
        }
        
        // reference_type = #{criteria.referenceType}
        if (criteria.getReferenceType() != null) {
            queryWrapper.eq(BusOrganRegistryFormsEntity::getReferenceType, criteria.getReferenceType());
        }
        
        // reference_number LIKE CONCAT('%',#{criteria.referenceNumber},'%')
        if (!StringUtil.isEmpty(criteria.getReferenceNumber())) {
            queryWrapper.like(BusOrganRegistryFormsEntity::getReferenceNumber, criteria.getReferenceNumber());
        }
        
        // creator_id LIKE CONCAT('%',#{criteria.creatorId},'%')
        if (!StringUtil.isEmpty(criteria.getCreatorId())) {
            queryWrapper.like(BusOrganRegistryFormsEntity::getCreatorId, criteria.getCreatorId());
        }

        // 执行分页查询
        IPage<BusOrganRegistryFormsEntity> result = this.mapper.selectPage(page, queryWrapper);

        return EntityCollection.create(
                result.getRecords(),
                criteria.getPageSize(),
                result.getTotal()
        );
    }

    @Override
    public BusOrganRegistryFormsEntity findByCondition(String institutionalTypeCode, String industryTypeCode, String regionCode) {
        LambdaQueryWrapper<BusOrganRegistryFormsEntity> queryWrapper = new LambdaQueryWrapper<>();
        
        // deleted = 0
        queryWrapper.eq(BusOrganRegistryFormsEntity::isDeleted, false);
        
        // 精确匹配条件
        queryWrapper.eq(BusOrganRegistryFormsEntity::getInstitutionalTypeCode, institutionalTypeCode);
        queryWrapper.eq(BusOrganRegistryFormsEntity::getIndustryTypeCode, industryTypeCode);
        queryWrapper.eq(BusOrganRegistryFormsEntity::getRegionCode, regionCode);

        queryWrapper.last("LIMIT 1");
        
        return this.mapper.selectOne(queryWrapper);
    }

    @Override
    public List<BusOrganRegistryFormsEntity> getByIds(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.mapper.selectBatchIds(ids);
    }

    @Override
    public void batchMarkAsDeleted(List<String> ids, Timestamp updateTime) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        
        LambdaUpdateWrapper<BusOrganRegistryFormsEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(BusOrganRegistryFormsEntity::getId, ids)
                     .eq(BusOrganRegistryFormsEntity::isDeleted, false)
                     .set(BusOrganRegistryFormsEntity::isDeleted, true)
                     .set(BusOrganRegistryFormsEntity::getLastUpdatedTime, updateTime);
        
        this.mapper.update(null, updateWrapper);
    }
}
