package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.domains.entities.MetaProjectEntity;
import com.bcxin.tenant.bcx.domains.mappers.MetaProjectMapper;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaProjectSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class MetaProjectRepositoryImpl extends RepositoryAbstract<MetaProjectEntity> implements MetaProjectRepository {
    private final MetaProjectMapper mapper;

    protected MetaProjectRepositoryImpl(MetaProjectMapper mapper) {
        super(mapper);
        this.mapper = mapper;
    }

    @Override
    public EntityCollection<MetaProjectEntity> search(MetaProjectSearchCriteria criteria) {
        // 创建 Page 对象
        Page<MetaProjectEntity> page = new Page<>(criteria.getPageIndex(), criteria.getPageSize());

        // 使用 LambdaQueryWrapper 构建查询条件
        LambdaQueryWrapper<MetaProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        
        // deleted = 0
        queryWrapper.eq(MetaProjectEntity::isDeleted, false);
        
        // 排除 id=1 的平台支撑项目
        queryWrapper.ne(MetaProjectEntity::getId, "1");
        
        // id = #{criteria.id}
        if (!StringUtil.isEmpty(criteria.getId())) {
            queryWrapper.eq(MetaProjectEntity::getId, criteria.getId());
        }
        
        // id IN (...)
        List<String> ids = criteria.getIds();
        if (ids != null && !ids.isEmpty()) {
            queryWrapper.in(MetaProjectEntity::getId, ids);
        }
        
        // name LIKE CONCAT('%',#{criteria.name},'%')
        if (!StringUtil.isEmpty(criteria.getName())) {
            queryWrapper.like(MetaProjectEntity::getName, criteria.getName());
        }
        
        // note LIKE CONCAT('%',#{criteria.note},'%')
        if (!StringUtil.isEmpty(criteria.getNote())) {
            queryWrapper.like(MetaProjectEntity::getNote, criteria.getNote());
        }
        
        // slug = #{criteria.slug}
        if (!StringUtil.isEmpty(criteria.getSlug())) {
            queryWrapper.eq(MetaProjectEntity::getSlug, criteria.getSlug());
        }
        
        // enabled = #{criteria.enabled}
        if (criteria.getEnabled() != null) {
            queryWrapper.eq(MetaProjectEntity::isEnabled, criteria.getEnabled());
        }
        
        // ORDER BY created_time DESC
        queryWrapper.orderByDesc(MetaProjectEntity::getCreatedTime);

        // 使用 mapper 查询数据
        IPage<MetaProjectEntity> result = mapper.selectPage(page, queryWrapper);

        // 转换为 EntityCollection
        return EntityCollection.create(
                result.getRecords(),
                criteria.getPageSize(),
                result.getTotal()
        );
    }
}
