package com.bcxin.tenant.bcx.domains.repositories;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bcxin.tenant.bcx.domains.entities.MetaMenuEntity;
import com.bcxin.tenant.bcx.domains.mappers.MetaMenuMapper;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaMenuSearchCriteria;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import org.springframework.stereotype.Repository;

/**
 * 菜单元数据仓库实现
 */
@Repository
public class MetaMenuRepositoryImpl extends RepositoryAbstract<MetaMenuEntity> implements MetaMenuRepository {
    private final MetaMenuMapper mapper;

    protected MetaMenuRepositoryImpl(MetaMenuMapper mapper) {
        super(mapper);
        this.mapper = mapper;
    }

    @Override
    public EntityCollection<MetaMenuEntity> search(MetaMenuSearchCriteria criteria) {
        // 创建 Page 对象
        Page<MetaMenuEntity> page = new Page<>(criteria.getPageIndex(), criteria.getPageSize());

        // 使用 mapper 查询数据
        IPage<MetaMenuEntity> result = mapper.selectPage(page, criteria); // 第二个参数是查询条件

        // 转换为 EntityCollection
        return EntityCollection.create(
                result.getRecords(),
                criteria.getPageSize(),
                result.getTotal()
        );
    }
}
