package com.bcxin.tenant.bcx.domains.typeHandlers;

import com.bcxin.tenant.bcx.domains.converters.GeoPointConverter;
import com.bcxin.tenant.bcx.domains.entities.valueTypes.GeoPointValueType;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 经维度坐标类型处理器
 *
 * @author chendy
 */
@MappedTypes({GeoPointValueType.class})
public class GeoPointTypeHandler extends BaseTypeHandler<GeoPointValueType> {

    GeoPointConverter converter = new GeoPointConverter();

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, GeoPointValueType parameter, JdbcType jdbcType) throws SQLException {
        ps.setBytes(i, converter.to(parameter));
    }

    @Override
    public GeoPointValueType getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return converter.from(rs.getBytes(columnName));
    }

    @Override
    public GeoPointValueType getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return converter.from(rs.getBytes(columnIndex));
    }

    @Override
    public GeoPointValueType getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return converter.from(cs.getBytes(columnIndex));
    }
}
