package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

/**
 * 企业注册表单
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "bus_organ_registry_forms", autoResultMap = true)
public class BusOrganRegistryFormsEntity extends EntityAbstract implements Aggregate {
    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 机构类型编码，关联sys_institutional_types.code
     */
    @TableField(value = "institutional_type_code")
    private String institutionalTypeCode;

    /**
     * 行业类型编码，关联sys_industry_types.code
     */
    @TableField(value = "industry_type_code")
    private String industryTypeCode;

    /**
     * 监管区域编码
     */
    @TableField(value = "region_code")
    private String regionCode;

    /**
     * 页面ID，关联meta_pages.id
     */
    @TableField(value = "page_id")
    private String pageId;

    /**
     * 创造者类型: 0-平台,1-租户,2-用户
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;

    /**
     * 创建者标识(平台组织Id/租户Id/用户Id)
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    /**
     * 创作者Id
     */
    @TableField(value = "creator_id")
    private String creatorId;

    /**
     * 最后修改人Id
     */
    @TableField(value = "last_updater_id")
    private String lastUpdaterId;

    /**
     * 最后修改时间
     */
    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    /**
     * 创建时间
     */
    @TableField(value = "created_time")
    private Timestamp createdTime;

    /**
     * 是否已删除: 0-未删除,1-已删除
     */
    @TableField(value = "deleted")
    private boolean deleted;

    /**
     * 标记为已删除
     */
    public void markAsDeleted() {
        this.deleted = true;
    }

    /**
     * 更新实体字段
     */
    public void change(String institutionalTypeCode, String industryTypeCode, String regionCode,
                       MetaCreatorReferenceType referenceType, String referenceNumber, String lastUpdaterId) {
        if (institutionalTypeCode != null) {
            this.institutionalTypeCode = institutionalTypeCode;
        }
        if (industryTypeCode != null) {
            this.industryTypeCode = industryTypeCode;
        }
        if (regionCode != null) {
            this.regionCode = regionCode;
        }
        if (referenceType != null) {
            this.referenceType = referenceType;
        }
        if (referenceNumber != null) {
            this.referenceNumber = referenceNumber;
        }
        this.lastUpdaterId = lastUpdaterId;
        this.lastUpdatedTime = new Timestamp(System.currentTimeMillis());
    }

    /**
     * 标记为已删除并更新时间戳
     */
    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.setLastUpdaterId(userModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    /**
     * 静态工厂方法，用于创建企业注册表单实体
     */
    public static BusOrganRegistryFormsEntity create(String id,
                                                     String institutionalTypeCode,
                                                     String industryTypeCode,
                                                     String regionCode,
                                                     String pageId,
                                                     MetaCreatorReferenceType referenceType,
                                                     String referenceNumber,
                                                     String creatorId) {
        BusOrganRegistryFormsEntity entity = new BusOrganRegistryFormsEntity();
        entity.setId(id);
        entity.setInstitutionalTypeCode(institutionalTypeCode);
        entity.setIndustryTypeCode(industryTypeCode);
        entity.setRegionCode(regionCode);
        entity.setPageId(pageId);
        entity.setReferenceType(referenceType);
        entity.setReferenceNumber(referenceNumber);
        entity.setCreatorId(creatorId);
        entity.setDeleted(false); // 默认未删除
        Timestamp now = new Timestamp(System.currentTimeMillis());
        entity.setCreatedTime(now);
        entity.setLastUpdatedTime(now);
        return entity;
    }
}



