/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="meta_pages", autoResultMap=true)
public class MetaPageEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private String id;
    @TableField(value="name")
    private String name;
    @TableField(value="begin_time")
    private Date beginTime;
    @TableField(value="end_time")
    private Date endTime;
    @TableField(value="attachment")
    private String attachment;
    @TableField(value="limited_count")
    private int limitedCount;
    @TableField(value="note")
    private String note;
    @TableField(value="slug")
    private String slug;
    @TableField(value="logo")
    private String logo;
    @TableField(value="page_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private PageType pageType;
    @TableField(value="project_id")
    private String projectId;
    @TableField(value="module_id")
    private String moduleId;
    @TableField(value="version")
    private long version;
    @TableField(value="form_json")
    private String formJson;
    @TableField(value="form_setting_json")
    private String formSettingJson;
    @TableField(value="business_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private PageBusinessType businessType;
    @TableField(value="table_name")
    private String tableName;
    @TableField(value="enable_bpm_flow")
    private boolean enableBPMFlow;
    @TableField(value="enable_anonymous_access")
    private boolean enableAnonymousAccess;
    @TableField(value="reference_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;
    @TableField(value="reference_number")
    private String referenceNumber;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="last_updater_id")
    private String lastUpdaterId;
    @TableField(value="creator_name")
    private String creatorName;
    @TableField(value="last_updater_name")
    private String lastUpdaterName;
    @TableField(value="deleted")
    private boolean deleted;
    @TableField(value="last_updated_Time")
    private Timestamp lastUpdatedTime;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="sync_2_identity")
    private boolean sync2Identity;

    public void markAsDeleted() {
        this.deleted = true;
    }

    public void changeMarkAsDeleted(TenantEmployeeContext.TenantUserModel userModel) {
        this.deleted = true;
        this.setLastUpdaterName(userModel.getName());
        this.setLastUpdaterId(userModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public void change(String name, TenantEmployeeContext.TenantUserModel userModel) {
        this.setName(name);
        this.setLastUpdaterName(userModel.getName());
        this.setLastUpdaterId(userModel.getId());
    }

    public void change(String name, String note, String slug, String logo, PageType pageType, PageBusinessType businessType, String tableName, Boolean enableBPMFlow, Boolean enableAnonymousAccess, boolean sync2Identity, Timestamp beginTime, Timestamp endTime, String attachment, int limitedCount, TenantEmployeeContext.TenantUserModel userModel) {
        this.setName(name);
        this.setNote(note);
        this.setSlug(slug);
        this.setLogo(logo);
        this.setPageType(pageType);
        this.setBusinessType(businessType);
        this.setTableName(tableName);
        this.setEnableBPMFlow(enableBPMFlow != null ? enableBPMFlow.booleanValue() : this.isEnableBPMFlow());
        this.setEnableAnonymousAccess(enableAnonymousAccess != null ? enableAnonymousAccess.booleanValue() : this.isEnableAnonymousAccess());
        this.setSync2Identity(sync2Identity);
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        this.setAttachment(attachment);
        this.setLimitedCount(limitedCount);
        this.setLastUpdaterName(userModel.getName());
        this.setLastUpdaterId(userModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public void change(String formJson, String formSettingJson, TenantEmployeeContext.TenantUserModel tenantUserModel) {
        this.setFormJson(formJson);
        this.setFormSettingJson(formSettingJson);
        this.setLastUpdaterName(tenantUserModel.getName());
        this.setLastUpdaterId(tenantUserModel.getId());
        this.setLastUpdatedTime(new Timestamp(System.currentTimeMillis()));
    }

    public void changeVersion(long newVersion) {
        this.setVersion(newVersion);
    }

    public static MetaPageEntity create(String id, String projectId, String moduleId, String name, String note, String slug, String logo, PageType pageType, PageBusinessType businessType, String tableName, boolean enableBPMFlow, boolean enableAnonymousAccess, String formJson, MetaCreatorReferenceType referenceType, String referenceNumber, String creatorId, String creatorName, boolean sync2Identity, Timestamp beginTime, Timestamp endTime, String attachment, int limitedCount) {
        MetaPageEntity entity = new MetaPageEntity();
        entity.setId(id);
        entity.setProjectId(projectId);
        entity.setModuleId(moduleId);
        entity.setName(name);
        entity.setNote(note);
        entity.setSlug(slug);
        entity.setLogo(logo);
        entity.setPageType(pageType);
        entity.setBusinessType(businessType);
        entity.setTableName(tableName);
        entity.setEnableBPMFlow(enableBPMFlow);
        entity.setEnableAnonymousAccess(enableAnonymousAccess);
        entity.setFormJson(formJson);
        entity.setReferenceType(referenceType);
        entity.setReferenceNumber(referenceNumber);
        entity.setCreatorId(creatorId);
        entity.setCreatorName(creatorName);
        entity.setSync2Identity(sync2Identity);
        entity.setBeginTime(beginTime);
        entity.setEndTime(endTime);
        entity.setAttachment(attachment);
        entity.setLimitedCount(limitedCount);
        entity.setVersion(1L);
        entity.setDeleted(false);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        entity.setCreatedTime(now);
        entity.setLastUpdatedTime(now);
        return entity;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public int getLimitedCount() {
        return this.limitedCount;
    }

    public String getNote() {
        return this.note;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getLogo() {
        return this.logo;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public long getVersion() {
        return this.version;
    }

    public String getFormJson() {
        return this.formJson;
    }

    public String getFormSettingJson() {
        return this.formSettingJson;
    }

    public PageBusinessType getBusinessType() {
        return this.businessType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isEnableBPMFlow() {
        return this.enableBPMFlow;
    }

    public boolean isEnableAnonymousAccess() {
        return this.enableAnonymousAccess;
    }

    public MetaCreatorReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getLastUpdaterName() {
        return this.lastUpdaterName;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public boolean isSync2Identity() {
        return this.sync2Identity;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public void setLimitedCount(int limitedCount) {
        this.limitedCount = limitedCount;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setPageType(PageType pageType) {
        this.pageType = pageType;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setFormJson(String formJson) {
        this.formJson = formJson;
    }

    public void setFormSettingJson(String formSettingJson) {
        this.formSettingJson = formSettingJson;
    }

    public void setBusinessType(PageBusinessType businessType) {
        this.businessType = businessType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setEnableBPMFlow(boolean enableBPMFlow) {
        this.enableBPMFlow = enableBPMFlow;
    }

    public void setEnableAnonymousAccess(boolean enableAnonymousAccess) {
        this.enableAnonymousAccess = enableAnonymousAccess;
    }

    public void setReferenceType(MetaCreatorReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setLastUpdaterName(String lastUpdaterName) {
        this.lastUpdaterName = lastUpdaterName;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setSync2Identity(boolean sync2Identity) {
        this.sync2Identity = sync2Identity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaPageEntity)) {
            return false;
        }
        MetaPageEntity other = (MetaPageEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getLimitedCount() != other.getLimitedCount()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isEnableBPMFlow() != other.isEnableBPMFlow()) {
            return false;
        }
        if (this.isEnableAnonymousAccess() != other.isEnableAnonymousAccess()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.isSync2Identity() != other.isSync2Identity()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$beginTime = this.getBeginTime();
        Date other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$attachment = this.getAttachment();
        String other$attachment = other.getAttachment();
        if (this$attachment == null ? other$attachment != null : !this$attachment.equals(other$attachment)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$logo = this.getLogo();
        String other$logo = other.getLogo();
        if (this$logo == null ? other$logo != null : !this$logo.equals(other$logo)) {
            return false;
        }
        PageType this$pageType = this.getPageType();
        PageType other$pageType = other.getPageType();
        if (this$pageType == null ? other$pageType != null : !this$pageType.equals(other$pageType)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$moduleId = this.getModuleId();
        String other$moduleId = other.getModuleId();
        if (this$moduleId == null ? other$moduleId != null : !this$moduleId.equals(other$moduleId)) {
            return false;
        }
        String this$formJson = this.getFormJson();
        String other$formJson = other.getFormJson();
        if (this$formJson == null ? other$formJson != null : !this$formJson.equals(other$formJson)) {
            return false;
        }
        String this$formSettingJson = this.getFormSettingJson();
        String other$formSettingJson = other.getFormSettingJson();
        if (this$formSettingJson == null ? other$formSettingJson != null : !this$formSettingJson.equals(other$formSettingJson)) {
            return false;
        }
        PageBusinessType this$businessType = this.getBusinessType();
        PageBusinessType other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        MetaCreatorReferenceType this$referenceType = this.getReferenceType();
        MetaCreatorReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$lastUpdaterId = this.getLastUpdaterId();
        String other$lastUpdaterId = other.getLastUpdaterId();
        if (this$lastUpdaterId == null ? other$lastUpdaterId != null : !this$lastUpdaterId.equals(other$lastUpdaterId)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$lastUpdaterName = this.getLastUpdaterName();
        String other$lastUpdaterName = other.getLastUpdaterName();
        if (this$lastUpdaterName == null ? other$lastUpdaterName != null : !this$lastUpdaterName.equals(other$lastUpdaterName)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        return !(this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaPageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimitedCount();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + (this.isEnableBPMFlow() ? 79 : 97);
        result = result * 59 + (this.isEnableAnonymousAccess() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + (this.isSync2Identity() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : $attachment.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $logo = this.getLogo();
        result = result * 59 + ($logo == null ? 43 : $logo.hashCode());
        PageType $pageType = this.getPageType();
        result = result * 59 + ($pageType == null ? 43 : $pageType.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $moduleId = this.getModuleId();
        result = result * 59 + ($moduleId == null ? 43 : $moduleId.hashCode());
        String $formJson = this.getFormJson();
        result = result * 59 + ($formJson == null ? 43 : $formJson.hashCode());
        String $formSettingJson = this.getFormSettingJson();
        result = result * 59 + ($formSettingJson == null ? 43 : $formSettingJson.hashCode());
        PageBusinessType $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        MetaCreatorReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $lastUpdaterId = this.getLastUpdaterId();
        result = result * 59 + ($lastUpdaterId == null ? 43 : $lastUpdaterId.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $lastUpdaterName = this.getLastUpdaterName();
        result = result * 59 + ($lastUpdaterName == null ? 43 : $lastUpdaterName.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        return result;
    }

    public String toString() {
        return "MetaPageEntity(id=" + this.getId() + ", name=" + this.getName() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", attachment=" + this.getAttachment() + ", limitedCount=" + this.getLimitedCount() + ", note=" + this.getNote() + ", slug=" + this.getSlug() + ", logo=" + this.getLogo() + ", pageType=" + this.getPageType() + ", projectId=" + this.getProjectId() + ", moduleId=" + this.getModuleId() + ", version=" + this.getVersion() + ", formJson=" + this.getFormJson() + ", formSettingJson=" + this.getFormSettingJson() + ", businessType=" + this.getBusinessType() + ", tableName=" + this.getTableName() + ", enableBPMFlow=" + this.isEnableBPMFlow() + ", enableAnonymousAccess=" + this.isEnableAnonymousAccess() + ", referenceType=" + this.getReferenceType() + ", referenceNumber=" + this.getReferenceNumber() + ", creatorId=" + this.getCreatorId() + ", lastUpdaterId=" + this.getLastUpdaterId() + ", creatorName=" + this.getCreatorName() + ", lastUpdaterName=" + this.getLastUpdaterName() + ", deleted=" + this.isDeleted() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdTime=" + this.getCreatedTime() + ", sync2Identity=" + this.isSync2Identity() + ")";
    }
}

