/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.wrappers;

import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageTableMappingDataSnapshot;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.ArgumentTenantException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class DynamicDataWrapper
implements Serializable {
    private DynamicMappingType mappingType;
    private DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot dsl;
    private Map<String, Object> params = new HashMap<String, Object>();
    private int pageIndex = 1;
    private int pageSize = 10;
    private boolean ignorePage = false;

    public DynamicDataWrapper() {
        this.getParams().put("domain_id", "#1");
        this.getParams().put("creator_id", "#1");
        this.getParams().put("last_updater_id", "#1");
        Timestamp now = Timestamp.from(Instant.now());
        this.getParams().put("created_time", now);
        this.getParams().put("created_time", now);
    }

    public static DynamicDataWrapper create(DynamicPageTableMappingDataSnapshot tableMapping, DynamicPageDataEntity entity, JsonProvider jsonProvider) {
        if (entity == null) {
            throw new ArgumentTenantException("\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38");
        }
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        tableMapping.buildAndFillWrapper(wrapper, entity, jsonProvider);
        return wrapper;
    }

    public static DynamicDataWrapper createForGetAndDeleteAction(DynamicPageTableMappingDataSnapshot tableMapping, String pageId, String id) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setMappingType(tableMapping.getMappingType());
        wrapper.getParams().put("pageId", pageId);
        wrapper.getParams().put("id", id);
        return wrapper;
    }

    public static DynamicDataWrapper createForSearch(DynamicPageTableMappingDataSnapshot tableMapping, Map<String, Object> params, boolean ignorePage, int pageIndex, int pageSize) {
        DynamicDataWrapper wrapper = new DynamicDataWrapper();
        wrapper.setDsl(tableMapping.getDsl());
        wrapper.setIgnorePage(ignorePage);
        wrapper.setPageIndex(pageIndex);
        wrapper.setPageSize(pageSize);
        wrapper.setMappingType(tableMapping.getMappingType());
        if (params != null) {
            wrapper.setParams(params);
        }
        return wrapper;
    }

    public void addParam(String key, Object value) {
        this.params.put(key, value);
    }

    public void addParams(Map<String, Object> params) {
        this.params.putAll(params);
    }

    public DynamicMappingType getMappingType() {
        return this.mappingType;
    }

    public DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot getDsl() {
        return this.dsl;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isIgnorePage() {
        return this.ignorePage;
    }

    protected void setMappingType(DynamicMappingType mappingType) {
        this.mappingType = mappingType;
    }

    protected void setDsl(DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot dsl) {
        this.dsl = dsl;
    }

    protected void setParams(Map<String, Object> params) {
        this.params = params;
    }

    protected void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    protected void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected void setIgnorePage(boolean ignorePage) {
        this.ignorePage = ignorePage;
    }
}

