/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.snapshots;

import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageDataJsonSnapshot;
import com.bcxin.tenant.bcx.domains.snapshots.DynamicPageValueSnapshot;
import com.bcxin.tenant.bcx.domains.wrappers.DynamicDataWrapper;
import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.DynamicMappingType;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.snapshots.SnapshotAbstract;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class DynamicPageTableMappingDataSnapshot
extends SnapshotAbstract {
    private String name;
    private String tableName;
    private DynamicMappingType mappingType;
    private DslDataMappingSnapshot dsl;
    private Map<String, String> columnMaps;
    private static DynamicPageTableMappingDataSnapshot _empty = new DynamicPageTableMappingDataSnapshot();

    public static DynamicPageTableMappingDataSnapshot empty() {
        return _empty;
    }

    public static boolean isEmpty(DynamicPageTableMappingDataSnapshot snapshot) {
        return snapshot == null || snapshot == _empty || snapshot.getDsl() == null;
    }

    public void buildAndFillWrapper(DynamicDataWrapper wrapper, DynamicPageDataEntity entity, JsonProvider jsonProvider) {
        DynamicPageDataJsonSnapshot snapshot = entity.getJsonSnapshot();
        HashMap<String, Object> oItems = new HashMap<String, Object>();
        HashMap<String, String> columnMappings = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(this.getColumnMaps())) {
            wrapper.addParams(snapshot.getItems());
            for (Map.Entry<String, Object> entry : snapshot.getItems().entrySet()) {
                wrapper.addParam(entry.getKey(), entry.getValue());
                oItems.put(entry.getKey(), entry.getValue());
            }
        } else {
            Set<String> allParamKeys = snapshot.getItems().keySet();
            for (String pKey : allParamKeys) {
                String matchedKey = this.getColumnMaps().get(pKey);
                if (matchedKey == null) {
                    wrapper.getParams().put(pKey, snapshot.getItems().get(pKey));
                    oItems.put(pKey, snapshot.getItems().get(pKey));
                    continue;
                }
                wrapper.getParams().put(pKey, snapshot.getItems().get(pKey));
                wrapper.getParams().put(matchedKey, snapshot.getItems().get(pKey));
                columnMappings.put(matchedKey, pKey);
            }
        }
        if (wrapper.getParams().containsKey("sys_dynamic_json")) {
            throw new BadTenantException(String.format("\u7cfb\u7edf\u53c2\u6570\u5b57\u6bb5\u5f02\u5e38: %s\u662f\u7cfb\u7edf\u4fdd\u7559\u5b57\u6bb5, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "sys_dynamic_json"));
        }
        DynamicPageValueSnapshot valueSnapshot = DynamicPageValueSnapshot.create(entity.getPageId(), entity.getVersion(), entity.getBusinessType(), oItems, columnMappings);
        wrapper.getParams().put("sys_dynamic_json", jsonProvider.getJson((Object)valueSnapshot));
        wrapper.getParams().put("pageId", entity.getPageId());
        wrapper.getParams().put("id", entity.getId());
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DynamicMappingType getMappingType() {
        return this.mappingType;
    }

    public DslDataMappingSnapshot getDsl() {
        return this.dsl;
    }

    public Map<String, String> getColumnMaps() {
        return this.columnMaps;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setMappingType(DynamicMappingType mappingType) {
        this.mappingType = mappingType;
    }

    public void setDsl(DslDataMappingSnapshot dsl) {
        this.dsl = dsl;
    }

    public void setColumnMaps(Map<String, String> columnMaps) {
        this.columnMaps = columnMaps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicPageTableMappingDataSnapshot)) {
            return false;
        }
        DynamicPageTableMappingDataSnapshot other = (DynamicPageTableMappingDataSnapshot)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        DynamicMappingType this$mappingType = this.getMappingType();
        DynamicMappingType other$mappingType = other.getMappingType();
        if (this$mappingType == null ? other$mappingType != null : !this$mappingType.equals(other$mappingType)) {
            return false;
        }
        DslDataMappingSnapshot this$dsl = this.getDsl();
        DslDataMappingSnapshot other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !((Object)((Object)this$dsl)).equals((Object)other$dsl)) {
            return false;
        }
        Map<String, String> this$columnMaps = this.getColumnMaps();
        Map<String, String> other$columnMaps = other.getColumnMaps();
        return !(this$columnMaps == null ? other$columnMaps != null : !((Object)this$columnMaps).equals(other$columnMaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicPageTableMappingDataSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        DynamicMappingType $mappingType = this.getMappingType();
        result = result * 59 + ($mappingType == null ? 43 : $mappingType.hashCode());
        DslDataMappingSnapshot $dsl = this.getDsl();
        result = result * 59 + ($dsl == null ? 43 : ((Object)((Object)$dsl)).hashCode());
        Map<String, String> $columnMaps = this.getColumnMaps();
        result = result * 59 + ($columnMaps == null ? 43 : ((Object)$columnMaps).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicPageTableMappingDataSnapshot(name=" + this.getName() + ", tableName=" + this.getTableName() + ", mappingType=" + this.getMappingType() + ", dsl=" + this.getDsl() + ", columnMaps=" + this.getColumnMaps() + ")";
    }

    public static class DslDataMappingSnapshot
    extends SnapshotAbstract {
        private String insertDsl;
        private String updateDsl;
        private String deleteDsl;
        private String queryDsl;
        private String queryDslById;

        public String getInsertDsl() {
            return this.insertDsl;
        }

        public String getUpdateDsl() {
            return this.updateDsl;
        }

        public String getDeleteDsl() {
            return this.deleteDsl;
        }

        public String getQueryDsl() {
            return this.queryDsl;
        }

        public String getQueryDslById() {
            return this.queryDslById;
        }

        public void setInsertDsl(String insertDsl) {
            this.insertDsl = insertDsl;
        }

        public void setUpdateDsl(String updateDsl) {
            this.updateDsl = updateDsl;
        }

        public void setDeleteDsl(String deleteDsl) {
            this.deleteDsl = deleteDsl;
        }

        public void setQueryDsl(String queryDsl) {
            this.queryDsl = queryDsl;
        }

        public void setQueryDslById(String queryDslById) {
            this.queryDslById = queryDslById;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DslDataMappingSnapshot)) {
                return false;
            }
            DslDataMappingSnapshot other = (DslDataMappingSnapshot)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$insertDsl = this.getInsertDsl();
            String other$insertDsl = other.getInsertDsl();
            if (this$insertDsl == null ? other$insertDsl != null : !this$insertDsl.equals(other$insertDsl)) {
                return false;
            }
            String this$updateDsl = this.getUpdateDsl();
            String other$updateDsl = other.getUpdateDsl();
            if (this$updateDsl == null ? other$updateDsl != null : !this$updateDsl.equals(other$updateDsl)) {
                return false;
            }
            String this$deleteDsl = this.getDeleteDsl();
            String other$deleteDsl = other.getDeleteDsl();
            if (this$deleteDsl == null ? other$deleteDsl != null : !this$deleteDsl.equals(other$deleteDsl)) {
                return false;
            }
            String this$queryDsl = this.getQueryDsl();
            String other$queryDsl = other.getQueryDsl();
            if (this$queryDsl == null ? other$queryDsl != null : !this$queryDsl.equals(other$queryDsl)) {
                return false;
            }
            String this$queryDslById = this.getQueryDslById();
            String other$queryDslById = other.getQueryDslById();
            return !(this$queryDslById == null ? other$queryDslById != null : !this$queryDslById.equals(other$queryDslById));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DslDataMappingSnapshot;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $insertDsl = this.getInsertDsl();
            result = result * 59 + ($insertDsl == null ? 43 : $insertDsl.hashCode());
            String $updateDsl = this.getUpdateDsl();
            result = result * 59 + ($updateDsl == null ? 43 : $updateDsl.hashCode());
            String $deleteDsl = this.getDeleteDsl();
            result = result * 59 + ($deleteDsl == null ? 43 : $deleteDsl.hashCode());
            String $queryDsl = this.getQueryDsl();
            result = result * 59 + ($queryDsl == null ? 43 : $queryDsl.hashCode());
            String $queryDslById = this.getQueryDslById();
            result = result * 59 + ($queryDslById == null ? 43 : $queryDslById.hashCode());
            return result;
        }

        public String toString() {
            return "DynamicPageTableMappingDataSnapshot.DslDataMappingSnapshot(insertDsl=" + this.getInsertDsl() + ", updateDsl=" + this.getUpdateDsl() + ", deleteDsl=" + this.getDeleteDsl() + ", queryDsl=" + this.getQueryDsl() + ", queryDslById=" + this.getQueryDslById() + ")";
        }
    }
}

