/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.components;

import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.events.DomainEvent;
import com.bcxin.tenant.bcx.infrastructures.events.EventDispatcher;
import com.bcxin.tenant.bcx.infrastructures.events.IntegrationDomainEvent;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class EventDispatcherImpl
implements EventDispatcher {
    private final ApplicationEventPublisher eventPublisher;
    private final KafkaTemplate kafkaTemplate;
    private final JsonProvider jsonProvider;

    public EventDispatcherImpl(ApplicationEventPublisher eventPublisher, KafkaTemplate kafkaTemplate, JsonProvider jsonProvider) {
        this.eventPublisher = eventPublisher;
        this.kafkaTemplate = kafkaTemplate;
        this.jsonProvider = jsonProvider;
    }

    public void dispatch(DomainEvent event) {
        this.eventPublisher.publishEvent((Object)event);
    }

    public void dispatch(IntegrationDomainEvent event) {
        String key = event.getKey(this.jsonProvider);
        if (StringUtil.isEmpty((String)key)) {
            throw new BadTenantException("\u65e0\u6548\u7684key\u4fe1\u606f");
        }
        if (StringUtil.isEmpty((String)event.getEventName())) {
            throw new BadTenantException("\u65e0\u6548\u7684\u961f\u5217\u4fe1\u606f");
        }
        String value = event.getValue(this.jsonProvider);
        int partition = Math.abs(key.hashCode() % 3);
        this.kafkaTemplate.send(event.getEventName(), Integer.valueOf(partition), (Object)key, (Object)value);
    }
}

