package com.bcxin.tenant.bcx.document.domains.dtos;

import lombok.Getter;

import java.util.Collection;
import java.util.Collections;

/**
 * 查询特定调度权限范围; 有该范围的情况; 可以不用根据组织Id进行过滤
 * 本功能目前针对内保单位进行的过滤
 */
@Getter
public class SearchSpecialPermissionScopeDTO {
    /**
     * 目前功能，仅内保单位的情况才会为true
     */
    private final boolean applySpecialPermissionScopeRule;

    private final Collection<String> scopeIds;

    public SearchSpecialPermissionScopeDTO(boolean applySpecialPermissionScopeRule, Collection<String> scopeIds) {
        this.applySpecialPermissionScopeRule = applySpecialPermissionScopeRule;
        this.scopeIds = scopeIds;
    }


    public static SearchSpecialPermissionScopeDTO create(
            boolean applySpecialPermissionScopeRule,
            Collection<String> scopeIds
    ) {
        SearchSpecialPermissionScopeDTO scopeDTO = new SearchSpecialPermissionScopeDTO(applySpecialPermissionScopeRule, scopeIds);

        return scopeDTO;
    }

    public static SearchSpecialPermissionScopeDTO createEmpty() {
        return new SearchSpecialPermissionScopeDTO(false, Collections.EMPTY_LIST);
    }
}
