package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.infrastructures.components.JsonProvider;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaPageSettingType;
import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class PageMetaSettingRequest extends RequestAbstract {
    @Schema(name = "name", title = "配置名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private final String name;

    @Schema(name = "note", title = "备注", requiredMode = Schema.RequiredMode.REQUIRED)
    private final String note;

    @Schema(name = "identity", title = "配置标识", requiredMode = Schema.RequiredMode.REQUIRED)
    private String identity;

    @Schema(name = "settingType", title = "类别", requiredMode = Schema.RequiredMode.REQUIRED)
    private MetaPageSettingType settingType;

    @Schema(name = "condition", title = "条件", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String condition;
    @Schema(name = "enabled", title = "是否启用", requiredMode = Schema.RequiredMode.REQUIRED)
    private boolean enabled;

    @Schema(name = "config", title = "json配置内容", requiredMode = Schema.RequiredMode.REQUIRED)
    public Object config;

    @JsonIgnore
    public String getJson(JsonProvider jsonProvider) {
        return jsonProvider.getJson(this.getConfig());
    }
}
