package com.bcxin.tenant.bcx.jdks.requests.pages;

import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Map;

@Data
public class PageDataActionRequest extends PageDataRequest {
    private DoActionType actionType;

    @Schema(hidden = true, title = "不显示此值, 此值来自于url地址的参数")
    private String pageId;

    private String id;

    private Map<String, Object> items;

    public static PageDataActionRequest create(String id, String pageId, DoActionType actionType,Map<String,Object> items) {
        PageDataActionRequest request = new PageDataActionRequest();
        request.setPageId(pageId);
        request.setId(id);
        request.setActionType(actionType);
        request.setItems(items);

        return request;
    }
}
