package com.bcxin.tenant.bcx.jdks;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.requests.metas.ProjectMetaRequest;
import com.bcxin.tenant.bcx.jdks.requests.metas.ProjectMetaSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.metas.ProjectMetaResponse;

import java.util.List;

public interface ProjectMetaRpcProvider {
    void create(ProjectMetaRequest request);

    void update(String id, ProjectMetaRequest request);

    void delete(String id);

    /**
     * 批量删除项目（逻辑删除）
     */
    void batchDelete(List<String> ids);

    EntityCollection<ProjectMetaResponse> search(ProjectMetaSearchRequest request);

    ProjectMetaResponse getById(String id);
}
