package com.bcxin.tenant.bcx.infrastructures.models;

import lombok.Data;

import java.util.ArrayList;
import java.util.Collection;

@Data
public class DataItemOption {
    private String text;
    private String value;

    private Collection<DataItemOption> children;

    public DataItemOption() {
        this.children = new ArrayList<>();
    }

    public void addOption(String text, String value) {
        Collection<DataItemOption> options = this.getChildren();
        if (options == null) {
            options = new ArrayList<>();
        }

        options.add(DataItemOption.create(text, value));
        this.setChildren(options);
    }

    public static DataItemOption create(String text, String value) {
        DataItemOption option = new DataItemOption();
        option.setText(text);
        option.setValue(value);

        return option;
    }
}
