package com.bcxin.tenant.bcx.infrastructures.valueTypes;

import lombok.Data;

@Data
public class GeoLocationValueType extends ValueTypeAbstract {
    private double lat;
    private double lon;
    private AddressRequest address;

    public GeoLocationValueType(){}

    public static GeoLocationValueType create(double lat,double lon,AddressRequest address) {
        GeoLocationValueType geoLocation = new GeoLocationValueType();
        geoLocation.setLon(lon);
        geoLocation.setLat(lat);
        geoLocation.setAddress(address);

        return geoLocation;
    }

    public static boolean isValidLocation(Double lat,Double lon) {
        if (lat == null || lon == null) {
            return false;
        }

        try {
            String latString = lat.toString();
            String lonString = lon.toString();

            if (!latString.contains(".") || !lonString.contains(".")) {
                return false;
            }

            return (latString.length() - latString.indexOf(".")) >= 4 &&
                    (lonString.length() - lonString.indexOf(".")) >= 4;
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return true;
    }

    @Data
    public static class AddressRequest extends ValueTypeAbstract {
        private String country;
        private String province;
        private String city;
        private String district;
        private String street;
        private String streetNum;
        private String poiName;
        private String cityCode;

        public AddressRequest(){}

        public static AddressRequest create(String country,String province,String city,String district,
                                            String street,String streetNum,String poiName,String cityCode) {
            AddressRequest addressRequest = new AddressRequest();
            addressRequest.setCity(city);
            addressRequest.setCountry(country);
            addressRequest.setProvince(province);
            addressRequest.setDistrict(district);
            addressRequest.setStreet(street);
            addressRequest.setStreetNum(streetNum);
            addressRequest.setPoiName(poiName);
            addressRequest.setCityCode(cityCode);

            return addressRequest;
        }

    }
}
