package com.bcxin.tenant.bcx.infrastructures.repositories;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;

import java.util.Collection;

public interface RepositoryBase<T extends Aggregate> {
    T getById(Object id);

    void insert(T data);

    void update(T data);

    void delete(Object id);

    EntityCollection<T> search(int pageIndex, int pageSize);

    Collection<T> getAll();
}
