/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.infrastructures;

import com.bcxin.tenant.bcx.infrastructures.InjectResolver;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TenantContext {
    public static final String FLOW_TAG_NAME = "FLOW_TAG_NAME";
    public static final String PROVIDER_FLOW_TAG_NAME = "PROVIDER_FLOW_TAG_NAME";
    public static final String REST_REQUEST_FLOW_TAG_NAME = "REST_REQUEST_FLOW_TAG_NAME";
    public static final String REST_VERSION = "REST_VERSION";
    private static volatile TenantContext _tenantContext;
    private InjectResolver injectResolver;
    private static final ThreadLocal<Map<Object, Object>> attachmentsContainer;
    private static final TenantEmployeeContext userContext;

    private TenantContext() {
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TenantContext getInstance() {
        if (_tenantContext != null) return _tenantContext;
        Class<TenantContext> clazz = TenantContext.class;
        synchronized (TenantContext.class) {
            if (_tenantContext != null) return _tenantContext;
            _tenantContext = new TenantContext();
            _tenantContext.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _tenantContext;
        }
    }

    public void setInjectResolver(InjectResolver injectResolver) {
        this.injectResolver = injectResolver;
    }

    public <T> T resolve(Class<T> tClass) {
        if (this.injectResolver == null) {
            throw new BadTenantException("InjectResolverFactory\u672a\u6b63\u786e\u521d\u59cb\u5316");
        }
        return this.injectResolver.resolve(tClass);
    }

    public <T> Collection<T> resolveAll(Class<T> tClass) {
        if (this.injectResolver == null) {
            throw new BadTenantException("InjectResolverFactory\u672a\u6b63\u786e\u521d\u59cb\u5316");
        }
        return this.injectResolver.resolveAll(tClass);
    }

    public void setValue(Object key, Object value) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        if (value == null) {
            attachments.remove(key);
        } else {
            attachments.put(key, value);
        }
        attachmentsContainer.set(attachments);
    }

    public void addAttachValues(String key, Object tagValue) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        try {
            attachments.put(key, tagValue);
            attachmentsContainer.set(attachments);
        }
        catch (Exception ex) {
            throw new BadTenantException(String.format("\u6dfb\u52a0AttachValues\u5f02\u5e38:%s", key), ex);
        }
    }

    public Object getAttachValue(String key) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        return attachments.get(key);
    }

    public <T> T getValueAndRemove(Object key) {
        Map<Object, Object> attachments = attachmentsContainer.get();
        if (attachments == null) {
            return null;
        }
        Object data = attachments.get(key);
        this.setValue(key, null);
        return (T)data;
    }

    public TenantEmployeeContext getUserContext() {
        return userContext;
    }

    static {
        attachmentsContainer = new ThreadLocal<Map<Object, Object>>(){

            @Override
            protected Map<Object, Object> initialValue() {
                return new HashMap<Object, Object>();
            }
        };
        userContext = new TenantEmployeeContext();
    }
}

