package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import lombok.Getter;

/**
 * 页面表单数据响应
 */
@Getter
public class PageFormDataResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String projectId;
    private final String moduleId;

    private final String logo;

    private final String formJson;
    private final String settingJson;
    
    private final boolean enableAnonymousAccess;

    public PageFormDataResponse(
            String projectId,
            String moduleId,
            String id, String name,
            String logo,
            String formJson, String settingJson,
            boolean enableAnonymousAccess) {
        this.id = id;
        this.projectId = projectId;
        this.moduleId = moduleId;
        this.name = name;
        this.logo = logo;
        this.formJson = formJson;
        this.settingJson = settingJson;
        this.enableAnonymousAccess = enableAnonymousAccess;
    }

    public static PageFormDataResponse create(
            String projectId,
            String moduleId,
            String id, String name,
            String logo,
            String formJson, String settingJson,
            boolean enableAnonymousAccess) {
        return new PageFormDataResponse(
                projectId, moduleId,
                id, name, logo, formJson, settingJson, enableAnonymousAccess);
    }
}

