package com.bcxin.tenant.bcx.jdks.responses.examEnrollmentCriterias;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.ExamReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import lombok.Getter;

import java.sql.Date;
import java.sql.Timestamp;

@Getter
public class ExamEnrollmentCriteriaResponse extends ResponseAbstract {
    private final String id;
    private final ExamReferenceType subjectType;

    private final String subjectName;
    private final String subjectNumber;
    private final String name;
    private final boolean sync2Saas;
    private final String note;

    private final Timestamp beginTime;
    private final Timestamp endTime;
    private final String attachment;
    private final int limitedCount;
    private final String slug;
    private final String logo;
    private final String projectId;
    private final String moduleId;
    private final boolean enableBPMFlow;
    private final boolean enableAnonymousAccess;

    private final Timestamp createdTime;

    private final String creatorName;

    public ExamEnrollmentCriteriaResponse(String id, ExamReferenceType subjectType,
                                          String subjectName,
                                          String subjectNumber,
                                          String name, boolean sync2Saas, String note, Timestamp beginTime, Timestamp endTime,
                                          String attachment, int limitedCount, String slug,
                                          String logo,
                                          String projectId, String moduleId, boolean enableBPMFlow,
                                          boolean enableAnonymousAccess,
                                          Timestamp createdTime,
                                          String creatorName) {
        this.id = id;
        this.subjectType = subjectType;
        this.subjectName = subjectName;
        this.subjectNumber = subjectNumber;
        this.name = name;
        this.sync2Saas = sync2Saas;
        this.note = note;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.attachment = attachment;
        this.limitedCount = limitedCount;
        this.slug = slug;
        this.logo = logo;
        this.projectId = projectId;
        this.moduleId = moduleId;
        this.enableBPMFlow = enableBPMFlow;
        this.enableAnonymousAccess = enableAnonymousAccess;
        this.createdTime = createdTime;
        this.creatorName = creatorName;
    }

    public static ExamEnrollmentCriteriaResponse create(String id, ExamReferenceType subjectType,
                                                        String subjectName,
                                                        String subjectNumber,
                                                            String name, boolean sync2Saas, String note, Timestamp beginTime, Timestamp endTime,
                                                            String attachment, int limitedCount, String slug,
                                                            String logo,
                                                            String projectId, String moduleId, boolean enableBPMFlow,
                                                            boolean enableAnonymousAccess,
                                                            Timestamp createdTime,
                                                        String creatorName) {
        return new ExamEnrollmentCriteriaResponse(
                id, subjectType, subjectName,subjectNumber, name,
                sync2Saas, note, beginTime, endTime, attachment, limitedCount,
                slug, logo, projectId, moduleId,
                enableBPMFlow, enableAnonymousAccess,
                createdTime,creatorName);
    }
}
