package com.bcxin.tenant.bcx.jdks.requests.pages;

import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;


@Data
public class PageDataSearchRequest extends SearchRequestAbstract {
    @Schema(name = "pageId", title = "页面Id", requiredMode = Schema.RequiredMode.REQUIRED,hidden = true)
    private String pageId;

    @Schema(name = "fields", title = "过滤条件", requiredMode = Schema.RequiredMode.REQUIRED)
    private Collection<DynamicConditionFieldValueType> fields;

    @Schema(name = "exportFileName", title = "导出的文件名", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String exportFileName;
}
