package com.bcxin.tenant.bcx.jdks.requests.pages;

import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Map;

@Data
public class MappingPageDataSearchRequest extends SearchRequestAbstract {
    @Schema(name = "mappingId", title = "映射表单的Id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String mappingId;

    @Schema(name = "fields", title = "过滤条件", requiredMode = Schema.RequiredMode.REQUIRED)
    private Collection<DynamicConditionFieldValueType> fields;

    @Schema(name = "exportFileName", title = "导出的文件名", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String exportFileName;

    @Schema(name = "forExport", title = "是否导出", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private boolean forExport;

    @Schema(name = "columnLabels", title = "列标签映射", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Map<String, String> columnLabels;
}
