package com.bcxin.tenant.bcx.jdks.requests.organregistry;

import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 企业注册表单搜索请求
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class OrganRegistryFormsSearchRequest extends SearchRequestAbstract {

    @Schema(name = "id", title = "主键", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true)
    private String id;

    @Schema(name = "ids", title = "主键列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true)
    private List<String> ids;

    @Schema(name = "institutionalTypeCode", title = "机构类型编码", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持模糊查询")
    private String institutionalTypeCode;

    @Schema(name = "industryTypeCode", title = "行业类型编码", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持模糊查询")
    private String industryTypeCode;

    @Schema(name = "regionCode", title = "监管区域编码", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持模糊查询")
    private String regionCode;

    @Schema(name = "pageId", title = "页面ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "关联meta_pages.id")
    private String pageId;

    @Schema(name = "referenceType", title = "创造者类型", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Integer referenceType;

    @Schema(name = "referenceNumber", title = "创建者标识", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持模糊查询")
    private String referenceNumber;

    @Schema(name = "creatorId", title = "创作者Id", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "支持模糊查询")
    private String creatorId;
}
