package com.bcxin.tenant.bcx.jdks.requests.organregistry;

import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import com.bcxin.tenant.bcx.infrastructures.enums.PageType;
import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 企业注册表单请求
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class OrganRegistryFormsRequest extends RequestAbstract {

    @Schema(name = "institutionalTypeCode", title = "机构类型编码", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "关联sys_institutional_types.code")
    private String institutionalTypeCode;

    @Schema(name = "industryTypeCode", title = "行业类型编码", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "关联sys_industry_types.code")
    private String industryTypeCode;

    @Schema(name = "regionCode", title = "监管区域编码", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String regionCode;

    @Schema(name = "pageId", title = "页面ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED, description = "关联meta_pages.id，新增时不需要传，系统自动创建")
    private String pageId;

    @Schema(name = "name", title = "表单名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;

    @Schema(name = "note", title = "备注", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String note;

    @Schema(name = "formJson", title = "结构", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String formJson;

    @Schema(name = "slug", title = "页面的url地址;未填的时候;系统自动生成", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String slug;

    @Schema(name = "logo", title = "logo", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String logo;

    @Schema(name = "pageType", title = "页面类型", requiredMode = Schema.RequiredMode.REQUIRED)
    private PageType pageType;

    @Schema(name = "businessType", title = "业务类型", requiredMode = Schema.RequiredMode.REQUIRED)
    private PageBusinessType businessType;

    @Schema(name = "tableName", title = "数据库-表名", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String tableName;

    @Schema(name = "enableBPMFlow", title = "是否启用流程", requiredMode = Schema.RequiredMode.NOT_REQUIRED, defaultValue = "false")
    private Boolean enableBPMFlow;

    @Schema(name = "enableAnonymousAccess", title = "是否启用匿名访问", requiredMode = Schema.RequiredMode.NOT_REQUIRED, defaultValue = "false")
    private Boolean enableAnonymousAccess;

    @Schema(name = "settingJson", title = "表单扩展设置, 过滤设置, 列表展示设置", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String settingJson;
}
