package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.MenuMediumType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Set;

@Data
@EqualsAndHashCode(callSuper = false)
public class MenuMetaRequest extends RequestAbstract {
    @Schema(name = "id", title = "主键ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String id;
    
    @Schema(name = "projectId", title = "项目ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String projectId;
    
    @Schema(name = "name", title = "菜单名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;
    
    @Schema(name = "pageId", title = "页面ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String pageId;
    
    @Schema(name = "parentId", title = "上级菜单ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String parentId;
    
    @Schema(name = "indexTreeId", title = "菜单层级树ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String indexTreeId;
    
    @Schema(name = "slug", title = "页面标识", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String slug;
    
    @Schema(name = "mediumType", title = "适配设备类型集合", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private Set<MenuMediumType> mediumType;
}
