package com.bcxin.tenant.bcx.jdks.requests.examEnrollmentCriterias;

import com.bcxin.tenant.bcx.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Timestamp;

@Data
public class UpdateExamEnrollmentCriteriaRequest extends RequestAbstract {
    @Schema(name = "name", title = "名称", requiredMode = Schema.RequiredMode.REQUIRED)
    private String name;

    @Schema(name = "sync2Saas", title = "同步到saas", requiredMode = Schema.RequiredMode.REQUIRED)
    private boolean sync2Saas;

    @Schema(name = "note", title = "备注")
    private String note;

    @Schema(name = "enableAnonymousAccess", title = "启用匿名访问")
    private boolean enableAnonymousAccess;

    @Schema(name = "enableBPMFlow", title = "启用BPM")
    private boolean enableBPMFlow;

    @Schema(name = "beginTime", title = "开始时间")
    private Timestamp beginTime;

    @Schema(name = "endTime", title = "结束时间")
    private Timestamp endTime;

    @Schema(name = "attachment", title = "附件")
    private String attachment;

    @Schema(name = "limitedCount", title = "提交限制; 默认为-1; 不限")
    private int limitedCount;

    /**
     * 页面路径地址; 初始化后不可改
     */
    @Schema(name = "slug", title = "页面标识; 提交后不可更改")
    private String slug;

    @Schema(name = "logo", title = "图标")
    private String logo;
}
