package com.bcxin.tenant.bcx.infrastructures;

import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;

import java.util.Collection;

public interface UnitWork {
    /**
     * 返回tid
     *
     * @return
     */
    String beginTransaction();

    /**
     * 提交tid的事务
     *
     * @param tid
     */
    void commit(String tid);

    /**
     * 重置所有
     */
    void detachAll();

    /**
     *
     */
    void detach(Aggregate aggregate);

    <T extends Aggregate> void detachAll(Collection<T> aggregates);

    void executeTran(Runnable runnable);

    /**
     * 调用commit之后不能再调用这个进行回滚
     * 但是很多异常都是再commit之前发生的
     * @param tid
     */
    void rollback(String tid);

    void executeNewTran(Runnable runnable);
}
