package com.bcxin.tenant.open.rest.apis.utils;

import com.bcxin.tenant.open.jdks.requests.BroadcastPoliceIndicentMessageContentItem;
import com.bcxin.tenant.open.jdks.requests.BroadcastTrtcMessageContentItem;
import com.bcxin.tenant.open.rest.apis.dtos.SocketPoliceIncidentMessageItem;
import com.bcxin.tenant.open.rest.apis.dtos.SocketTrtcMessageItem;

public class SocketMessageUtil {

    /**
     * 警情上报，输入消息与发送消息转换
     */
    public static SocketPoliceIncidentMessageItem policeIncidentRequestMessageToResponse(BroadcastPoliceIndicentMessageContentItem content) {
        return SocketPoliceIncidentMessageItem.create(
                content.getId(),
                content.getCategory(),
                content.getEmployeeId(), content.getEmpName(),
                content.getAddress(),
                content.getTencentUserId(),
                content.getStationId(),
                content.getStationName(),
                content.getSuperDepartId(),
                content.getCreatedTime(),
                content.getLatitude(),
                content.getLongitude()
        );
    }

    /**
     * trtc，输入消息与发送消息转换
     */
    public static SocketTrtcMessageItem trtcRequestMessageToResponse(BroadcastTrtcMessageContentItem content){
        return SocketTrtcMessageItem.create(content.getRoomId(),content.getAction(),content.getTencentUserId());
    }
}
