package com.bcxin.tenant.open.rest.apis.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.bcxin.tenant.open.rest.apis.easyexcel.BooleanCellWriteHandler;
import com.bcxin.tenant.open.rest.apis.easyexcel.CustomRowWriteHandler;
import com.bcxin.tenant.open.rest.apis.easyexcel.ExportConsumer;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public class ExcelExportUtil {
    /**
     * https://github.com/alibaba/easyexcel
     * @param response
     * @param tClass
     * @param name
     * @param data
     * @param <T>
     * @throws IOException
     */
    public static <T> void export(HttpServletResponse response, Class<T> tClass, String name, Collection<T> data)
            throws IOException {
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        String fileName = URLEncoder.encode(name, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write(response.getOutputStream(), tClass).sheet(name)
                .doWrite(data);
    }

    public static <T> void export(HttpServletResponse response, Class<T> tClass, String name,
                                  ExportConsumer data)
            throws IOException {
        // 这里注意 有同学反应使用swagger 会导致各种问题，请直接用浏览器或者用postman
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        // 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
        String fileName = URLEncoder.encode(name, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + URLEncoder.encode(name, "UTF-8") + ".xlsx");
        try (ExcelWriter writer = EasyExcel.write(response.getOutputStream(), tClass)
                .excelType(ExcelTypeEnum.XLSX)
                .registerWriteHandler(new CustomRowWriteHandler())
                .registerWriteHandler(new BooleanCellWriteHandler())
                .build()) {
            WriteSheet sheet = EasyExcel.writerSheet(0, name).build();
            data.accept(writer, sheet);
            writer.finish();
        }
    }
}
