package com.bcxin.tenant.open.rest.apis.easyexcel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

import java.util.List;

public class BooleanCellWriteHandler implements CellWriteHandler {


    @Override
    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder,
                                 List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        // 在这里实现布尔值的处理逻辑
        if (cell != null && cell.getCellTypeEnum() != null && cell.getCellTypeEnum().equals(CellType.BOOLEAN)) {
            // 获取布尔值
            Boolean booleanValue = cell.getBooleanCellValue();

            // 根据需要进行处理，例如设置样式、修改值等
            // 这里仅是个简单示例，你可以根据实际需求进行更多的定制
            if (booleanValue != null && booleanValue) {
                // 如果是 true，可以修改样式或其他操作
                cell.setCellValue("是");
            } else {
                // 如果是 false，可以修改样式或其他操作
                cell.setCellValue("否");
            }
        }
    }

}
