package com.bcxin.tenant.open.rest.apis.dtos;

import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import lombok.Data;

import java.io.Serializable;

/**
 * websocket发出的trtc消息详情
 */
@Data
public class SocketTrtcMessageItem implements Serializable {
    private Long roomId;
    private String action;
    private String tencentUserId;

    private SocketTrtcMessageItem(Long roomId, String action, String tencentUserId){
        this.roomId = roomId;
        this.action = action;
        this.tencentUserId = tencentUserId;
    }
    public static SocketTrtcMessageItem create(Long roomId, TRTCActionType action, String tencentUserId) {
        return new SocketTrtcMessageItem(roomId, action.getName(),tencentUserId);
    }
}
