package com.bcxin.tenant.open.rest.apis.dtos;

import com.bcxin.tenant.open.jdks.requests.enums.BroadcastMessageType;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import lombok.Getter;

@Getter
public class SocketSessionMessageResponse extends ResponseAbstract {
    private final BroadcastMessageType type;
    private final SocketSentMessage message;


    public SocketSessionMessageResponse(BroadcastMessageType type, SocketSentMessage message) {
        this.type = type;
        this.message = message;
    }

    public static  SocketSessionMessageResponse create(BroadcastMessageType type, SocketSentMessage message) {
        return new SocketSessionMessageResponse(type,message);
    }
}
