package com.bcxin.tenant.open.rest.apis.dtos;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * websocket发出的警情上报消息的详情
 */
@Data
public class SocketPoliceIncidentMessageItem implements Serializable {
    private String id;
    private String employeeId;
    private String empName;
    private String address;
    private String superDepartId;
    private Timestamp createdTime;
    private Double latitude;
    private Double longitude;
    private String stationName;
    private String stationId;
    private PoliceEventCategory category;

    private String tencentUserId;


    public SocketPoliceIncidentMessageItem() {
    }

    public static SocketPoliceIncidentMessageItem create(
            String id,
            PoliceEventCategory category,
            String employeeId,
            String empName,
            String address,
            String tencentUserId, String stationId, String stationName,
            String superDepartId, Timestamp createdTime,
            Double latitude,
            Double longitude) {
        SocketPoliceIncidentMessageItem data = new SocketPoliceIncidentMessageItem();
        data.setAddress(address);
        data.setCategory(category);
        data.setId(id);
        data.setSuperDepartId(superDepartId);
        data.setCreatedTime(createdTime);
        data.setLatitude(latitude);
        data.setLongitude(longitude);
        data.setEmployeeId(employeeId);
        data.setEmpName(empName);

        return data;
    }

    public void assignTencentUserInfo(String tencentUserId, String stationId, String stationName) {
        this.setTencentUserId(tencentUserId);
        this.setStationName(stationName);
        this.setStationId(stationId);
    }
}
