package com.bcxin.tenant.open.rest.apis.dtos;

import lombok.Data;

import java.util.Collection;
import java.util.Collections;

/**
 * websocket 发出的警情上报的消息
 */
@Data
public class SocketPoliceIncidentMessage extends SocketSentMessage {
    private Collection<SocketPoliceIncidentMessageItem> contents;

    private SocketPoliceIncidentMessage(Collection<SocketPoliceIncidentMessageItem> contents){
        this.contents = contents;
    }

    public static SocketPoliceIncidentMessage create(Collection<SocketPoliceIncidentMessageItem> contents){
        return new SocketPoliceIncidentMessage(contents);
    }

    public static SocketPoliceIncidentMessage createEmptyMessage(){
        return new SocketPoliceIncidentMessage(Collections.EMPTY_LIST);
    }
}
